package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class NetworkResourceUtilization(networkInBytesPerSecond: scala.Option[primitives.GenericString] = None, networkOutBytesPerSecond: scala.Option[primitives.GenericString] = None, networkPacketsInPerSecond: scala.Option[primitives.GenericString] = None, networkPacketsOutPerSecond: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization = {
    import NetworkResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization.builder().optionallyWith(networkInBytesPerSecond.map(value => value: java.lang.String))(_.networkInBytesPerSecond).optionallyWith(networkOutBytesPerSecond.map(value => value: java.lang.String))(_.networkOutBytesPerSecond).optionallyWith(networkPacketsInPerSecond.map(value => value: java.lang.String))(_.networkPacketsInPerSecond).optionallyWith(networkPacketsOutPerSecond.map(value => value: java.lang.String))(_.networkPacketsOutPerSecond).build()
  }
  def asReadOnly: NetworkResourceUtilization.ReadOnly = NetworkResourceUtilization.wrap(buildAwsValue())
}
object NetworkResourceUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: NetworkResourceUtilization = NetworkResourceUtilization(networkInBytesPerSecondValue.map(value => value), networkOutBytesPerSecondValue.map(value => value), networkPacketsInPerSecondValue.map(value => value), networkPacketsOutPerSecondValue.map(value => value))
    def networkInBytesPerSecondValue: scala.Option[primitives.GenericString]
    def networkOutBytesPerSecondValue: scala.Option[primitives.GenericString]
    def networkPacketsInPerSecondValue: scala.Option[primitives.GenericString]
    def networkPacketsOutPerSecondValue: scala.Option[primitives.GenericString]
    def networkInBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkInBytesPerSecond", networkInBytesPerSecondValue)
    def networkOutBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkOutBytesPerSecond", networkOutBytesPerSecondValue)
    def networkPacketsInPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkPacketsInPerSecond", networkPacketsInPerSecondValue)
    def networkPacketsOutPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkPacketsOutPerSecond", networkPacketsOutPerSecondValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization) extends NetworkResourceUtilization.ReadOnly {
    override def networkInBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.networkInBytesPerSecond()).map(value => value: primitives.GenericString)
    override def networkOutBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.networkOutBytesPerSecond()).map(value => value: primitives.GenericString)
    override def networkPacketsInPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.networkPacketsInPerSecond()).map(value => value: primitives.GenericString)
    override def networkPacketsOutPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.networkPacketsOutPerSecond()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization): ReadOnly = new Wrapper(impl)
}