package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Impact(maxImpact: primitives.GenericDouble, totalImpact: scala.Option[primitives.GenericDouble] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Impact = {
    import Impact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Impact.builder().maxImpact(maxImpact: java.lang.Double).optionallyWith(totalImpact.map(value => value: java.lang.Double))(_.totalImpact).build()
  }
  def asReadOnly: Impact.ReadOnly = Impact.wrap(buildAwsValue())
}
object Impact {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Impact] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Impact = Impact(maxImpactValue, totalImpactValue.map(value => value))
    def maxImpactValue: primitives.GenericDouble
    def totalImpactValue: scala.Option[primitives.GenericDouble]
    def maxImpact: ZIO[Any, Nothing, primitives.GenericDouble] = ZIO.succeed(maxImpactValue)
    def totalImpact: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericDouble] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalImpact", totalImpactValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Impact) extends Impact.ReadOnly {
    override def maxImpactValue: primitives.GenericDouble = impl.maxImpact(): primitives.GenericDouble
    override def totalImpactValue: scala.Option[primitives.GenericDouble] = scala.Option(impl.totalImpact()).map(value => value: primitives.GenericDouble)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Impact): ReadOnly = new Wrapper(impl)
}