package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait Granularity { def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity }
object Granularity {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.Granularity): Granularity = value match {
    case software.amazon.awssdk.services.costexplorer.model.Granularity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.MONTHLY =>
      val r = MONTHLY
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.HOURLY =>
      val r = HOURLY
      r
  }
  case object unknownToSdkVersion extends Granularity { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity = software.amazon.awssdk.services.costexplorer.model.Granularity.UNKNOWN_TO_SDK_VERSION }
  case object DAILY extends Granularity { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity = software.amazon.awssdk.services.costexplorer.model.Granularity.DAILY }
  case object MONTHLY extends Granularity { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity = software.amazon.awssdk.services.costexplorer.model.Granularity.MONTHLY }
  case object HOURLY extends Granularity { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity = software.amazon.awssdk.services.costexplorer.model.Granularity.HOURLY }
}