package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomalySubscriptionsRequest(subscriptionArnList: scala.Option[Iterable[primitives.Value]] = None, monitorArn: scala.Option[primitives.GenericString] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.PageSize] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest = {
    import GetAnomalySubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest.builder().optionallyWith(subscriptionArnList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.subscriptionArnList).optionallyWith(monitorArn.map(value => value: java.lang.String))(_.monitorArn).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: GetAnomalySubscriptionsRequest.ReadOnly = GetAnomalySubscriptionsRequest.wrap(buildAwsValue())
}
object GetAnomalySubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomalySubscriptionsRequest = GetAnomalySubscriptionsRequest(subscriptionArnListValue.map(value => value), monitorArnValue.map(value => value), nextPageTokenValue.map(value => value), maxResultsValue.map(value => value))
    def subscriptionArnListValue: scala.Option[List[primitives.Value]]
    def monitorArnValue: scala.Option[primitives.GenericString]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.PageSize]
    def subscriptionArnList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Value]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionArnList", subscriptionArnListValue)
    def monitorArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PageSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest) extends GetAnomalySubscriptionsRequest.ReadOnly {
    override def subscriptionArnListValue: scala.Option[List[primitives.Value]] = scala.Option(impl.subscriptionArnList()).map(value => value.asScala.map { item => 
      item: primitives.Value
    }.toList)
    override def monitorArnValue: scala.Option[primitives.GenericString] = scala.Option(impl.monitorArn()).map(value => value: primitives.GenericString)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.PageSize] = scala.Option(impl.maxResults()).map(value => value: primitives.PageSize)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest): ReadOnly = new Wrapper(impl)
}