package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategoryInheritedValueDimension(
    dimensionName: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimensionName
    ] = None,
    dimensionKey: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension = {
    import CostCategoryInheritedValueDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension
      .builder()
      .optionallyWith(dimensionName.map(value => value.unwrap))(_.dimensionName)
      .optionallyWith(dimensionKey.map(value => value: java.lang.String))(
        _.dimensionKey
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension
      .wrap(buildAwsValue())
}
object CostCategoryInheritedValueDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension =
      io.github.vigoo.zioaws.costexplorer.model
        .CostCategoryInheritedValueDimension(
          dimensionNameValue.map(value => value),
          dimensionKeyValue.map(value => value)
        )
    def dimensionNameValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimensionName
    ]
    def dimensionKeyValue: Option[GenericString]
    def dimensionName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimensionName
    ] = AwsError.unwrapOptionField("dimensionName", dimensionNameValue)
    def dimensionKey: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("dimensionKey", dimensionKeyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly {
    override def dimensionNameValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimensionName
    ] = scala
      .Option(impl.dimensionName())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimensionName
          .wrap(value)
      )
    override def dimensionKeyValue: Option[GenericString] =
      scala.Option(impl.dimensionKey()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly =
    new Wrapper(impl)
}
