package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  AttributeValue,
  AttributeType,
  Value
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DimensionValuesWithAttributes(
    value: Option[Value] = None,
    attributes: Option[Map[AttributeType, AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes = {
    import DimensionValuesWithAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
      .wrap(buildAwsValue())
}
object DimensionValuesWithAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes =
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes(
        valueValue.map(value => value),
        attributesValue.map(value => value)
      )
    def valueValue: Option[Value]
    def attributesValue: Option[Map[AttributeType, AttributeValue]]
    def value: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", valueValue)
    def attributes: ZIO[Any, AwsError, Map[AttributeType, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes
  ) extends io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly {
    override def valueValue: Option[Value] =
      scala.Option(impl.value()).map(value => value: Value)
    override def attributesValue: Option[Map[AttributeType, AttributeValue]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttributeType) -> (value: AttributeValue)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes
  ): io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly =
    new Wrapper(impl)
}
