package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{ZonedDateTime, Arn}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteCostCategoryDefinitionResponse(
    costCategoryArn: Option[Arn] = None,
    effectiveEnd: Option[ZonedDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse = {
    import DeleteCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse
      .builder()
      .optionallyWith(costCategoryArn.map(value => value: java.lang.String))(
        _.costCategoryArn
      )
      .optionallyWith(effectiveEnd.map(value => value: java.lang.String))(
        _.effectiveEnd
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse
      .wrap(buildAwsValue())
}
object DeleteCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .DeleteCostCategoryDefinitionResponse(
          costCategoryArnValue.map(value => value),
          effectiveEndValue.map(value => value)
        )
    def costCategoryArnValue: Option[Arn]
    def effectiveEndValue: Option[ZonedDateTime]
    def costCategoryArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def effectiveEnd: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly {
    override def costCategoryArnValue: Option[Arn] =
      scala.Option(impl.costCategoryArn()).map(value => value: Arn)
    override def effectiveEndValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveEnd()).map(value => value: ZonedDateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse
  ): io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
