package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRightsizingRecommendationResponse(
    metadata: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata
    ] = None,
    summary: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary
    ] = None,
    rightsizingRecommendations: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation
    ]] = None,
    nextPageToken: Option[NextPageToken] = None,
    configuration: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse = {
    import GetRightsizingRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .optionallyWith(
        rightsizingRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rightsizingRecommendations)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse
      .wrap(buildAwsValue())
}
object GetRightsizingRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetRightsizingRecommendationResponse(
          metadataValue.map(value => value.editable),
          summaryValue.map(value => value.editable),
          rightsizingRecommendationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value),
          configurationValue.map(value => value.editable)
        )
    def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly
    ]
    def summaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly
    ]
    def rightsizingRecommendationsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly
    ]]
    def nextPageTokenValue: Option[NextPageToken]
    def configurationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ]
    def metadata: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadataValue)
    def summary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summaryValue)
    def rightsizingRecommendations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "rightsizingRecommendations",
      rightsizingRecommendationsValue
    )
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def configuration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configurationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly {
    override def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly
    ] = scala
      .Option(impl.metadata())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata
          .wrap(value)
      )
    override def summaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly
    ] = scala
      .Option(impl.summary())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary
          .wrap(value)
      )
    override def rightsizingRecommendationsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly
    ]] = scala
      .Option(impl.rightsizingRecommendations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def configurationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetRightsizingRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
