package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  Arn,
  NullableNonNegativeDouble,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAnomalySubscriptionRequest(
    subscriptionArn: GenericString,
    threshold: Option[NullableNonNegativeDouble] = None,
    frequency: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    ] = None,
    monitorArnList: Option[Iterable[Arn]] = None,
    subscribers: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.Subscriber]
    ] = None,
    subscriptionName: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest = {
    import UpdateAnomalySubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest
      .builder()
      .subscriptionArn(subscriptionArn: java.lang.String)
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        monitorArnList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.monitorArnList)
      .optionallyWith(
        subscribers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribers)
      .optionallyWith(subscriptionName.map(value => value: java.lang.String))(
        _.subscriptionName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest
      .wrap(buildAwsValue())
}
object UpdateAnomalySubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .UpdateAnomalySubscriptionRequest(
          subscriptionArnValue,
          thresholdValue.map(value => value),
          frequencyValue.map(value => value),
          monitorArnListValue.map(value => value),
          subscribersValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          subscriptionNameValue.map(value => value)
        )
    def subscriptionArnValue: GenericString
    def thresholdValue: Option[NullableNonNegativeDouble]
    def frequencyValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    ]
    def monitorArnListValue: Option[List[Arn]]
    def subscribersValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly]
    ]
    def subscriptionNameValue: Option[GenericString]
    def subscriptionArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(subscriptionArnValue)
    def threshold: ZIO[Any, AwsError, NullableNonNegativeDouble] =
      AwsError.unwrapOptionField("threshold", thresholdValue)
    def frequency: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    ] = AwsError.unwrapOptionField("frequency", frequencyValue)
    def monitorArnList: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("monitorArnList", monitorArnListValue)
    def subscribers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribers", subscribersValue)
    def subscriptionName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("subscriptionName", subscriptionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest.ReadOnly {
    override def subscriptionArnValue: GenericString =
      impl.subscriptionArn(): GenericString
    override def thresholdValue: Option[NullableNonNegativeDouble] = scala
      .Option(impl.threshold())
      .map(value => value: NullableNonNegativeDouble)
    override def frequencyValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    ] = scala
      .Option(impl.frequency())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
          .wrap(value)
      )
    override def monitorArnListValue: Option[List[Arn]] = scala
      .Option(impl.monitorArnList())
      .map(value =>
        value.asScala.map { item =>
          item: Arn
        }.toList
      )
    override def subscribersValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly]
    ] = scala
      .Option(impl.subscribers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Subscriber.wrap(item)
        }.toList
      )
    override def subscriptionNameValue: Option[GenericString] =
      scala.Option(impl.subscriptionName()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest
  ): io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
