package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  Estimated,
  MetricName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResultByTime(
    timePeriod: Option[io.github.vigoo.zioaws.costexplorer.model.DateInterval] =
      None,
    total: Option[
      Map[MetricName, io.github.vigoo.zioaws.costexplorer.model.MetricValue]
    ] = None,
    groups: Option[Iterable[io.github.vigoo.zioaws.costexplorer.model.Group]] =
      None,
    estimated: Option[Estimated] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ResultByTime = {
    import ResultByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResultByTime
      .builder()
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(
        total.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.total)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(estimated.map(value => value: java.lang.Boolean))(
        _.estimated
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ResultByTime.wrap(buildAwsValue())
}
object ResultByTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ResultByTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.ResultByTime =
      io.github.vigoo.zioaws.costexplorer.model.ResultByTime(
        timePeriodValue.map(value => value.editable),
        totalValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.editable
          })
        ),
        groupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        estimatedValue.map(value => value)
      )
    def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ]
    def totalValue: Option[Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]]
    def groupsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly]]
    def estimatedValue: Option[Estimated]
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def total: ZIO[Any, AwsError, Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]] = AwsError.unwrapOptionField("total", totalValue)
    def groups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groupsValue)
    def estimated: ZIO[Any, AwsError, Estimated] =
      AwsError.unwrapOptionField("estimated", estimatedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ResultByTime
  ) extends io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly {
    override def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = scala
      .Option(impl.timePeriod())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(value)
      )
    override def totalValue: Option[Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]] = scala
      .Option(impl.total())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: MetricName) -> io.github.vigoo.zioaws.costexplorer.model.MetricValue
              .wrap(value)
          })
          .toMap
      )
    override def groupsValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly]
    ] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Group.wrap(item)
        }.toList
      )
    override def estimatedValue: Option[Estimated] =
      scala.Option(impl.estimated()).map(value => value: Estimated)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ResultByTime
  ): io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly =
    new Wrapper(impl)
}
