package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  GenericBoolean,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RDSInstanceDetails(
    family: Option[GenericString] = None,
    instanceType: Option[GenericString] = None,
    region: Option[GenericString] = None,
    databaseEngine: Option[GenericString] = None,
    databaseEdition: Option[GenericString] = None,
    deploymentOption: Option[GenericString] = None,
    licenseModel: Option[GenericString] = None,
    currentGeneration: Option[GenericBoolean] = None,
    sizeFlexEligible: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails = {
    import RDSInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails
      .builder()
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(databaseEngine.map(value => value: java.lang.String))(
        _.databaseEngine
      )
      .optionallyWith(databaseEdition.map(value => value: java.lang.String))(
        _.databaseEdition
      )
      .optionallyWith(deploymentOption.map(value => value: java.lang.String))(
        _.deploymentOption
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(
        _.currentGeneration
      )
      .optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(
        _.sizeFlexEligible
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails
      .wrap(buildAwsValue())
}
object RDSInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails =
      io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails(
        familyValue.map(value => value),
        instanceTypeValue.map(value => value),
        regionValue.map(value => value),
        databaseEngineValue.map(value => value),
        databaseEditionValue.map(value => value),
        deploymentOptionValue.map(value => value),
        licenseModelValue.map(value => value),
        currentGenerationValue.map(value => value),
        sizeFlexEligibleValue.map(value => value)
      )
    def familyValue: Option[GenericString]
    def instanceTypeValue: Option[GenericString]
    def regionValue: Option[GenericString]
    def databaseEngineValue: Option[GenericString]
    def databaseEditionValue: Option[GenericString]
    def deploymentOptionValue: Option[GenericString]
    def licenseModelValue: Option[GenericString]
    def currentGenerationValue: Option[GenericBoolean]
    def sizeFlexEligibleValue: Option[GenericBoolean]
    def family: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("family", familyValue)
    def instanceType: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def databaseEngine: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("databaseEngine", databaseEngineValue)
    def databaseEdition: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("databaseEdition", databaseEditionValue)
    def deploymentOption: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("deploymentOption", deploymentOptionValue)
    def licenseModel: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("licenseModel", licenseModelValue)
    def currentGeneration: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly {
    override def familyValue: Option[GenericString] =
      scala.Option(impl.family()).map(value => value: GenericString)
    override def instanceTypeValue: Option[GenericString] =
      scala.Option(impl.instanceType()).map(value => value: GenericString)
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def databaseEngineValue: Option[GenericString] =
      scala.Option(impl.databaseEngine()).map(value => value: GenericString)
    override def databaseEditionValue: Option[GenericString] =
      scala.Option(impl.databaseEdition()).map(value => value: GenericString)
    override def deploymentOptionValue: Option[GenericString] =
      scala.Option(impl.deploymentOption()).map(value => value: GenericString)
    override def licenseModelValue: Option[GenericString] =
      scala.Option(impl.licenseModel()).map(value => value: GenericString)
    override def currentGenerationValue: Option[GenericBoolean] =
      scala.Option(impl.currentGeneration()).map(value => value: GenericBoolean)
    override def sizeFlexEligibleValue: Option[GenericBoolean] =
      scala.Option(impl.sizeFlexEligible()).map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.RDSInstanceDetails.ReadOnly =
    new Wrapper(impl)
}
