package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCostAndUsageWithResourcesResponse(
    nextPageToken: Option[NextPageToken] = None,
    groupDefinitions: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition]
    ] = None,
    resultsByTime: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.ResultByTime]
    ] = None,
    dimensionValueAttributes: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse = {
    import GetCostAndUsageWithResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse
      .builder()
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(
        groupDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupDefinitions)
      .optionallyWith(
        resultsByTime.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultsByTime)
      .optionallyWith(
        dimensionValueAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensionValueAttributes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse
      .wrap(buildAwsValue())
}
object GetCostAndUsageWithResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetCostAndUsageWithResourcesResponse(
          nextPageTokenValue.map(value => value),
          groupDefinitionsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          resultsByTimeValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          dimensionValueAttributesValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def nextPageTokenValue: Option[NextPageToken]
    def groupDefinitionsValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ]
    def resultsByTimeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly]
    ]
    def dimensionValueAttributesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ]]
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def groupDefinitions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("groupDefinitions", groupDefinitionsValue)
    def resultsByTime: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly
    ]] = AwsError.unwrapOptionField("resultsByTime", resultsByTimeValue)
    def dimensionValueAttributes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dimensionValueAttributes",
      dimensionValueAttributesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly {
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def groupDefinitionsValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ] = scala
      .Option(impl.groupDefinitions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.wrap(item)
        }.toList
      )
    override def resultsByTimeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.ResultByTime.ReadOnly]
    ] = scala
      .Option(impl.resultsByTime())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ResultByTime.wrap(item)
        }.toList
      )
    override def dimensionValueAttributesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ]] = scala
      .Option(impl.dimensionValueAttributes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
