package io.github.vigoo.zioaws.costexplorer
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  Key,
  AttributeType,
  MetricName,
  CostCategoryValue,
  CostCategoryName,
  GenericString,
  Arn,
  Value,
  Entity,
  AttributeValue
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type AmortizedRecurringFee = String
    type AmortizedUpfrontFee = String
    type Arn = String
    type AttributeType = String
    type AttributeValue = String
    type CostCategoryMaxResults = Int
    type CostCategoryName = String
    type CostCategoryValue = String
    type CoverageHoursPercentage = String
    type CoverageNormalizedUnitsPercentage = String
    type Entity = String
    type Estimated = Boolean
    type GenericBoolean = Boolean
    type GenericDouble = Double
    type GenericString = String
    type GroupDefinitionKey = String
    type Key = String
    type MaxResults = Int
    type MetricAmount = String
    type MetricName = String
    type MetricUnit = String
    type NetRISavings = String
    type NextPageToken = String
    type NonNegativeInteger = Int
    type NullableNonNegativeDouble = Double
    type OnDemandCost = String
    type OnDemandCostOfRIHoursUsed = String
    type OnDemandHours = String
    type OnDemandNormalizedUnits = String
    type PageSize = Int
    type PredictionIntervalLevel = Int
    type PurchasedHours = String
    type PurchasedUnits = String
    type RICostForUnusedHours = String
    type RealizedSavings = String
    type ReservationGroupKey = String
    type ReservationGroupValue = String
    type ReservedHours = String
    type ReservedNormalizedUnits = String
    type SavingsPlanArn = String
    type SearchString = String
    type SortDefinitionKey = String
    type SubscriberAddress = String
    type TagKey = String
    type TotalActualHours = String
    type TotalActualUnits = String
    type TotalAmortizedFee = String
    type TotalPotentialRISavings = String
    type TotalRunningHours = String
    type TotalRunningNormalizedUnits = String
    type UnrealizedSavings = String
    type UnusedHours = String
    type UnusedUnits = String
    type UtilizationPercentage = String
    type UtilizationPercentageInUnits = String
    type Value = String
    type YearMonthDay = String
    type ZonedDateTime = String
  }
  type Anomalies = List[io.github.vigoo.zioaws.costexplorer.model.Anomaly]
  type AnomalyMonitors =
    List[io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor]
  type AnomalySubscriptions =
    List[io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription]
  type Attributes = Map[AttributeType, AttributeValue]
  type CostCategoryNamesList = List[CostCategoryName]
  type CostCategoryProcessingStatusList =
    List[io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus]
  type CostCategoryReferencesList =
    List[io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference]
  type CostCategoryRulesList =
    List[io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule]
  type CostCategorySplitChargeRuleParameterValuesList = List[GenericString]
  type CostCategorySplitChargeRuleParametersList = List[
    io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter
  ]
  type CostCategorySplitChargeRuleTargetsList = List[GenericString]
  type CostCategorySplitChargeRulesList =
    List[io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule]
  type CostCategoryValuesList = List[CostCategoryValue]
  type CoveragesByTime =
    List[io.github.vigoo.zioaws.costexplorer.model.CoverageByTime]
  type DimensionValuesWithAttributesList = List[
    io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
  ]
  type Expressions = List[io.github.vigoo.zioaws.costexplorer.model.Expression]
  type FindingReasonCodes =
    List[io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode]
  type ForecastResultsByTime =
    List[io.github.vigoo.zioaws.costexplorer.model.ForecastResult]
  type GroupDefinitions =
    List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition]
  type Groups = List[io.github.vigoo.zioaws.costexplorer.model.Group]
  type Keys = List[Key]
  type MatchOptions =
    List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]
  type MetricNames = List[MetricName]
  type Metrics =
    Map[MetricName, io.github.vigoo.zioaws.costexplorer.model.MetricValue]
  type MonitorArnList = List[Arn]
  type PlatformDifferences =
    List[io.github.vigoo.zioaws.costexplorer.model.PlatformDifference]
  type ReservationCoverageGroups =
    List[io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup]
  type ReservationPurchaseRecommendationDetails = List[
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail
  ]
  type ReservationPurchaseRecommendations = List[
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation
  ]
  type ReservationUtilizationGroups =
    List[io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup]
  type ResultsByTime =
    List[io.github.vigoo.zioaws.costexplorer.model.ResultByTime]
  type RightsizingRecommendationList =
    List[io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation]
  type RootCauses = List[io.github.vigoo.zioaws.costexplorer.model.RootCause]
  type SavingsPlansCoverages =
    List[io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage]
  type SavingsPlansDataTypes =
    List[io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType]
  type SavingsPlansPurchaseRecommendationDetailList = List[
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
  ]
  type SavingsPlansUtilizationDetails = List[
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail
  ]
  type SavingsPlansUtilizationsByTime = List[
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime
  ]
  type SortDefinitions =
    List[io.github.vigoo.zioaws.costexplorer.model.SortDefinition]
  type Subscribers = List[io.github.vigoo.zioaws.costexplorer.model.Subscriber]
  type TagList = List[Entity]
  type TagValuesList = List[io.github.vigoo.zioaws.costexplorer.model.TagValues]
  type TargetInstancesList =
    List[io.github.vigoo.zioaws.costexplorer.model.TargetInstance]
  type UtilizationsByTime =
    List[io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime]
  type Values = List[Value]
}
