package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{ZonedDateTime, Arn}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateCostCategoryDefinitionResponse(
    costCategoryArn: Option[Arn] = None,
    effectiveStart: Option[ZonedDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse = {
    import UpdateCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse
      .builder()
      .optionallyWith(costCategoryArn.map(value => value: java.lang.String))(
        _.costCategoryArn
      )
      .optionallyWith(effectiveStart.map(value => value: java.lang.String))(
        _.effectiveStart
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse
      .wrap(buildAwsValue())
}
object UpdateCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .UpdateCostCategoryDefinitionResponse(
          costCategoryArnValue.map(value => value),
          effectiveStartValue.map(value => value)
        )
    def costCategoryArnValue: Option[Arn]
    def effectiveStartValue: Option[ZonedDateTime]
    def costCategoryArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def effectiveStart: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveStart", effectiveStartValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly {
    override def costCategoryArnValue: Option[Arn] =
      scala.Option(impl.costCategoryArn()).map(value => value: Arn)
    override def effectiveStartValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveStart()).map(value => value: ZonedDateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse
  ): io.github.vigoo.zioaws.costexplorer.model.UpdateCostCategoryDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
