package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.SortOrder
  ): io.github.vigoo.zioaws.costexplorer.model.SortOrder = value match {
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SortOrder =
      software.amazon.awssdk.services.costexplorer.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING
      extends io.github.vigoo.zioaws.costexplorer.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SortOrder =
      software.amazon.awssdk.services.costexplorer.model.SortOrder.ASCENDING
  }
  case object DESCENDING
      extends io.github.vigoo.zioaws.costexplorer.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SortOrder =
      software.amazon.awssdk.services.costexplorer.model.SortOrder.DESCENDING
  }
}
