package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkResourceUtilization(
    networkInBytesPerSecond: Option[GenericString] = None,
    networkOutBytesPerSecond: Option[GenericString] = None,
    networkPacketsInPerSecond: Option[GenericString] = None,
    networkPacketsOutPerSecond: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization = {
    import NetworkResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization
      .builder()
      .optionallyWith(
        networkInBytesPerSecond.map(value => value: java.lang.String)
      )(_.networkInBytesPerSecond)
      .optionallyWith(
        networkOutBytesPerSecond.map(value => value: java.lang.String)
      )(_.networkOutBytesPerSecond)
      .optionallyWith(
        networkPacketsInPerSecond.map(value => value: java.lang.String)
      )(_.networkPacketsInPerSecond)
      .optionallyWith(
        networkPacketsOutPerSecond.map(value => value: java.lang.String)
      )(_.networkPacketsOutPerSecond)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization
      .wrap(buildAwsValue())
}
object NetworkResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization =
      io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization(
        networkInBytesPerSecondValue.map(value => value),
        networkOutBytesPerSecondValue.map(value => value),
        networkPacketsInPerSecondValue.map(value => value),
        networkPacketsOutPerSecondValue.map(value => value)
      )
    def networkInBytesPerSecondValue: Option[GenericString]
    def networkOutBytesPerSecondValue: Option[GenericString]
    def networkPacketsInPerSecondValue: Option[GenericString]
    def networkPacketsOutPerSecondValue: Option[GenericString]
    def networkInBytesPerSecond: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "networkInBytesPerSecond",
        networkInBytesPerSecondValue
      )
    def networkOutBytesPerSecond: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "networkOutBytesPerSecond",
        networkOutBytesPerSecondValue
      )
    def networkPacketsInPerSecond: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "networkPacketsInPerSecond",
        networkPacketsInPerSecondValue
      )
    def networkPacketsOutPerSecond: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "networkPacketsOutPerSecond",
        networkPacketsOutPerSecondValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly {
    override def networkInBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.networkInBytesPerSecond())
      .map(value => value: GenericString)
    override def networkOutBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.networkOutBytesPerSecond())
      .map(value => value: GenericString)
    override def networkPacketsInPerSecondValue: Option[GenericString] = scala
      .Option(impl.networkPacketsInPerSecond())
      .map(value => value: GenericString)
    override def networkPacketsOutPerSecondValue: Option[GenericString] = scala
      .Option(impl.networkPacketsOutPerSecond())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.NetworkResourceUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.NetworkResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
