package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  GenericBoolean,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ESInstanceDetails(
    instanceClass: Option[GenericString] = None,
    instanceSize: Option[GenericString] = None,
    region: Option[GenericString] = None,
    currentGeneration: Option[GenericBoolean] = None,
    sizeFlexEligible: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails = {
    import ESInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails
      .builder()
      .optionallyWith(instanceClass.map(value => value: java.lang.String))(
        _.instanceClass
      )
      .optionallyWith(instanceSize.map(value => value: java.lang.String))(
        _.instanceSize
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(
        _.currentGeneration
      )
      .optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(
        _.sizeFlexEligible
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails
      .wrap(buildAwsValue())
}
object ESInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails =
      io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails(
        instanceClassValue.map(value => value),
        instanceSizeValue.map(value => value),
        regionValue.map(value => value),
        currentGenerationValue.map(value => value),
        sizeFlexEligibleValue.map(value => value)
      )
    def instanceClassValue: Option[GenericString]
    def instanceSizeValue: Option[GenericString]
    def regionValue: Option[GenericString]
    def currentGenerationValue: Option[GenericBoolean]
    def sizeFlexEligibleValue: Option[GenericBoolean]
    def instanceClass: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceClass", instanceClassValue)
    def instanceSize: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceSize", instanceSizeValue)
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def currentGeneration: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly {
    override def instanceClassValue: Option[GenericString] =
      scala.Option(impl.instanceClass()).map(value => value: GenericString)
    override def instanceSizeValue: Option[GenericString] =
      scala.Option(impl.instanceSize()).map(value => value: GenericString)
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def currentGenerationValue: Option[GenericBoolean] =
      scala.Option(impl.currentGeneration()).map(value => value: GenericBoolean)
    override def sizeFlexEligibleValue: Option[GenericBoolean] =
      scala.Option(impl.sizeFlexEligible()).map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.ESInstanceDetails.ReadOnly =
    new Wrapper(impl)
}
