package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericDouble
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TotalImpactFilter(
    numericOperator: io.github.vigoo.zioaws.costexplorer.model.NumericOperator,
    startValue: GenericDouble,
    endValue: Option[GenericDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter = {
    import TotalImpactFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter
      .builder()
      .numericOperator(numericOperator.unwrap)
      .startValue(startValue: java.lang.Double)
      .optionallyWith(endValue.map(value => value: java.lang.Double))(
        _.endValue
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter
      .wrap(buildAwsValue())
}
object TotalImpactFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter =
      io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter(
        numericOperatorValue,
        startValueValue,
        endValueValue.map(value => value)
      )
    def numericOperatorValue
        : io.github.vigoo.zioaws.costexplorer.model.NumericOperator
    def startValueValue: GenericDouble
    def endValueValue: Option[GenericDouble]
    def numericOperator: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.NumericOperator
    ] = ZIO.succeed(numericOperatorValue)
    def startValue: ZIO[Any, Nothing, GenericDouble] =
      ZIO.succeed(startValueValue)
    def endValue: ZIO[Any, AwsError, GenericDouble] =
      AwsError.unwrapOptionField("endValue", endValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter
  ) extends io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly {
    override def numericOperatorValue
        : io.github.vigoo.zioaws.costexplorer.model.NumericOperator =
      io.github.vigoo.zioaws.costexplorer.model.NumericOperator
        .wrap(impl.numericOperator())
    override def startValueValue: GenericDouble =
      impl.startValue(): GenericDouble
    override def endValueValue: Option[GenericDouble] =
      scala.Option(impl.endValue()).map(value => value: GenericDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter
  ): io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly =
    new Wrapper(impl)
}
