package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  GenericBoolean,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetInstance(
    estimatedMonthlyCost: Option[GenericString] = None,
    estimatedMonthlySavings: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None,
    defaultTargetInstance: Option[GenericBoolean] = None,
    resourceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails
    ] = None,
    expectedResourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization
    ] = None,
    platformDifferences: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.PlatformDifference]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.TargetInstance = {
    import TargetInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TargetInstance
      .builder()
      .optionallyWith(
        estimatedMonthlyCost.map(value => value: java.lang.String)
      )(_.estimatedMonthlyCost)
      .optionallyWith(
        estimatedMonthlySavings.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavings)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(
        defaultTargetInstance.map(value => value: java.lang.Boolean)
      )(_.defaultTargetInstance)
      .optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(
        _.resourceDetails
      )
      .optionallyWith(
        expectedResourceUtilization.map(value => value.buildAwsValue())
      )(_.expectedResourceUtilization)
      .optionallyWith(
        platformDifferences.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformDifferencesWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.TargetInstance
      .wrap(buildAwsValue())
}
object TargetInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.TargetInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.TargetInstance =
      io.github.vigoo.zioaws.costexplorer.model.TargetInstance(
        estimatedMonthlyCostValue.map(value => value),
        estimatedMonthlySavingsValue.map(value => value),
        currencyCodeValue.map(value => value),
        defaultTargetInstanceValue.map(value => value),
        resourceDetailsValue.map(value => value.editable),
        expectedResourceUtilizationValue.map(value => value.editable),
        platformDifferencesValue.map(value => value)
      )
    def estimatedMonthlyCostValue: Option[GenericString]
    def estimatedMonthlySavingsValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def defaultTargetInstanceValue: Option[GenericBoolean]
    def resourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ]
    def expectedResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ]
    def platformDifferencesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.PlatformDifference]
    ]
    def estimatedMonthlyCost: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("estimatedMonthlyCost", estimatedMonthlyCostValue)
    def estimatedMonthlySavings: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavings",
        estimatedMonthlySavingsValue
      )
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def defaultTargetInstance: ZIO[Any, AwsError, GenericBoolean] = AwsError
      .unwrapOptionField("defaultTargetInstance", defaultTargetInstanceValue)
    def resourceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("resourceDetails", resourceDetailsValue)
    def expectedResourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "expectedResourceUtilization",
      expectedResourceUtilizationValue
    )
    def platformDifferences: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.PlatformDifference
    ]] = AwsError.unwrapOptionField(
      "platformDifferences",
      platformDifferencesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.TargetInstance
  ) extends io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly {
    override def estimatedMonthlyCostValue: Option[GenericString] = scala
      .Option(impl.estimatedMonthlyCost())
      .map(value => value: GenericString)
    override def estimatedMonthlySavingsValue: Option[GenericString] = scala
      .Option(impl.estimatedMonthlySavings())
      .map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
    override def defaultTargetInstanceValue: Option[GenericBoolean] = scala
      .Option(impl.defaultTargetInstance())
      .map(value => value: GenericBoolean)
    override def resourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ] = scala
      .Option(impl.resourceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.wrap(value)
      )
    override def expectedResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.expectedResourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization
          .wrap(value)
      )
    override def platformDifferencesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.PlatformDifference]
    ] = scala
      .Option(impl.platformDifferences())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.PlatformDifference
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.TargetInstance
  ): io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly =
    new Wrapper(impl)
}
