package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservationPurchaseRecommendationResponse(
    metadata: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata
    ] = None,
    recommendations: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation
    ]] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse = {
    import GetReservationPurchaseRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse
      .wrap(buildAwsValue())
}
object GetReservationPurchaseRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetReservationPurchaseRecommendationResponse(
          metadataValue.map(value => value.editable),
          recommendationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly
    ]
    def recommendationsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly
    ]]
    def nextPageTokenValue: Option[NextPageToken]
    def metadata: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadataValue)
    def recommendations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendationsValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly {
    override def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly
    ] = scala
      .Option(impl.metadata())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata
          .wrap(value)
      )
    override def recommendationsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly
    ]] = scala
      .Option(impl.recommendations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
