package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  AttributeValue,
  AttributeType
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationCoverageGroup(
    attributes: Option[Map[AttributeType, AttributeValue]] = None,
    coverage: Option[io.github.vigoo.zioaws.costexplorer.model.Coverage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup = {
    import ReservationCoverageGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(coverage.map(value => value.buildAwsValue()))(_.coverage)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup
      .wrap(buildAwsValue())
}
object ReservationCoverageGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup =
      io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup(
        attributesValue.map(value => value),
        coverageValue.map(value => value.editable)
      )
    def attributesValue: Option[Map[AttributeType, AttributeValue]]
    def coverageValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly]
    def attributes: ZIO[Any, AwsError, Map[AttributeType, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
    def coverage: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly
    ] = AwsError.unwrapOptionField("coverage", coverageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly {
    override def attributesValue: Option[Map[AttributeType, AttributeValue]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttributeType) -> (value: AttributeValue)
            })
            .toMap
        )
    override def coverageValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly] =
      scala
        .Option(impl.coverage())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.Coverage.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly =
    new Wrapper(impl)
}
