package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyRecommendationDetail(
    targetInstances: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.TargetInstance]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail = {
    import ModifyRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail
      .builder()
      .optionallyWith(
        targetInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetInstances)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail
      .wrap(buildAwsValue())
}
object ModifyRecommendationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail =
      io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail(
        targetInstancesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def targetInstancesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly]
    ]
    def targetInstances: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("targetInstances", targetInstancesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail
  ) extends io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly {
    override def targetInstancesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.TargetInstance.ReadOnly]
    ] = scala
      .Option(impl.targetInstances())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.TargetInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail
  ): io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly =
    new Wrapper(impl)
}
