package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.Arn
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCostCategoryDefinitionRequest(costCategoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest = {
    import DeleteCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest
      .builder()
      .costCategoryArn(costCategoryArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .DeleteCostCategoryDefinitionRequest(costCategoryArnValue)
    def costCategoryArnValue: Arn
    def costCategoryArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(costCategoryArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest.ReadOnly {
    override def costCategoryArnValue: Arn = impl.costCategoryArn(): Arn
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest
  ): io.github.vigoo.zioaws.costexplorer.model.DeleteCostCategoryDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
