package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.OnDemandCost
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoverageCost(onDemandCost: Option[OnDemandCost] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CoverageCost = {
    import CoverageCost.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageCost
      .builder()
      .optionallyWith(onDemandCost.map(value => value: java.lang.String))(
        _.onDemandCost
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CoverageCost.wrap(buildAwsValue())
}
object CoverageCost {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CoverageCost
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CoverageCost =
      io.github.vigoo.zioaws.costexplorer.model
        .CoverageCost(onDemandCostValue.map(value => value))
    def onDemandCostValue: Option[OnDemandCost]
    def onDemandCost: ZIO[Any, AwsError, OnDemandCost] =
      AwsError.unwrapOptionField("onDemandCost", onDemandCostValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageCost
  ) extends io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly {
    override def onDemandCostValue: Option[OnDemandCost] =
      scala.Option(impl.onDemandCost()).map(value => value: OnDemandCost)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageCost
  ): io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly =
    new Wrapper(impl)
}
