package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait RightsizingType {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.RightsizingType
}
object RightsizingType {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.RightsizingType
  ): io.github.vigoo.zioaws.costexplorer.model.RightsizingType = value match {
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.TERMINATE =>
      val r = TERMINATE
      r
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.MODIFY =>
      val r = MODIFY
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.RightsizingType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RightsizingType =
      software.amazon.awssdk.services.costexplorer.model.RightsizingType.UNKNOWN_TO_SDK_VERSION
  }
  case object TERMINATE
      extends io.github.vigoo.zioaws.costexplorer.model.RightsizingType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RightsizingType =
      software.amazon.awssdk.services.costexplorer.model.RightsizingType.TERMINATE
  }
  case object MODIFY
      extends io.github.vigoo.zioaws.costexplorer.model.RightsizingType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RightsizingType =
      software.amazon.awssdk.services.costexplorer.model.RightsizingType.MODIFY
  }
}
