package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationPurchaseRecommendation(
    accountScope: Option[
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = None,
    lookbackPeriodInDays: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = None,
    termInYears: Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] =
      None,
    paymentOption: Option[
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = None,
    serviceSpecification: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification
    ] = None,
    recommendationDetails: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail
    ]] = None,
    recommendationSummary: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation = {
    import ReservationPurchaseRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation
      .builder()
      .optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope)
      .optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(
        _.lookbackPeriodInDays
      )
      .optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(serviceSpecification.map(value => value.buildAwsValue()))(
        _.serviceSpecification
      )
      .optionallyWith(
        recommendationDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationDetails)
      .optionallyWith(
        recommendationSummary.map(value => value.buildAwsValue())
      )(_.recommendationSummary)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation
      .wrap(buildAwsValue())
}
object ReservationPurchaseRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation =
      io.github.vigoo.zioaws.costexplorer.model
        .ReservationPurchaseRecommendation(
          accountScopeValue.map(value => value),
          lookbackPeriodInDaysValue.map(value => value),
          termInYearsValue.map(value => value),
          paymentOptionValue.map(value => value),
          serviceSpecificationValue.map(value => value.editable),
          recommendationDetailsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          recommendationSummaryValue.map(value => value.editable)
        )
    def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope]
    def lookbackPeriodInDaysValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays]
    def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears]
    def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption]
    def serviceSpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ]
    def recommendationDetailsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly
    ]]
    def recommendationSummaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly
    ]
    def accountScope: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def lookbackPeriodInDays: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = AwsError.unwrapOptionField(
      "lookbackPeriodInDays",
      lookbackPeriodInDaysValue
    )
    def termInYears: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TermInYears
    ] = AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def serviceSpecification: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSpecification",
      serviceSpecificationValue
    )
    def recommendationDetails: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationDetails",
      recommendationDetailsValue
    )
    def recommendationSummary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationSummary",
      recommendationSummaryValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly {
    override def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope] = scala
      .Option(impl.accountScope())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AccountScope.wrap(value)
      )
    override def lookbackPeriodInDaysValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = scala
      .Option(impl.lookbackPeriodInDays())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
          .wrap(value)
      )
    override def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] = scala
      .Option(impl.termInYears())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.TermInYears.wrap(value)
      )
    override def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption] =
      scala
        .Option(impl.paymentOption())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.PaymentOption.wrap(value)
        )
    override def serviceSpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ] = scala
      .Option(impl.serviceSpecification())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification
          .wrap(value)
      )
    override def recommendationDetailsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly
    ]] = scala
      .Option(impl.recommendationDetails())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail
            .wrap(item)
        }.toList
      )
    override def recommendationSummaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly
    ] = scala
      .Option(impl.recommendationSummary())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendation.ReadOnly =
    new Wrapper(impl)
}
