package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{MetricName, Key}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Group(
    keys: Option[Iterable[Key]] = None,
    metrics: Option[
      Map[MetricName, io.github.vigoo.zioaws.costexplorer.model.MetricValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Group
      .builder()
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.metrics)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Group
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Group =
      io.github.vigoo.zioaws.costexplorer.model.Group(
        keysValue.map(value => value),
        metricsValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.editable
          })
        )
      )
    def keysValue: Option[List[Key]]
    def metricsValue: Option[Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]]
    def keys: ZIO[Any, AwsError, List[Key]] =
      AwsError.unwrapOptionField("keys", keysValue)
    def metrics: ZIO[Any, AwsError, Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metricsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Group
  ) extends io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly {
    override def keysValue: Option[List[Key]] = scala
      .Option(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          item: Key
        }.toList
      )
    override def metricsValue: Option[Map[
      MetricName,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: MetricName) -> io.github.vigoo.zioaws.costexplorer.model.MetricValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Group
  ): io.github.vigoo.zioaws.costexplorer.model.Group.ReadOnly = new Wrapper(
    impl
  )
}
