package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ForecastResult(
    timePeriod: Option[io.github.vigoo.zioaws.costexplorer.model.DateInterval] =
      None,
    meanValue: Option[GenericString] = None,
    predictionIntervalLowerBound: Option[GenericString] = None,
    predictionIntervalUpperBound: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ForecastResult = {
    import ForecastResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ForecastResult
      .builder()
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(meanValue.map(value => value: java.lang.String))(
        _.meanValue
      )
      .optionallyWith(
        predictionIntervalLowerBound.map(value => value: java.lang.String)
      )(_.predictionIntervalLowerBound)
      .optionallyWith(
        predictionIntervalUpperBound.map(value => value: java.lang.String)
      )(_.predictionIntervalUpperBound)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ForecastResult
      .wrap(buildAwsValue())
}
object ForecastResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ForecastResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.ForecastResult =
      io.github.vigoo.zioaws.costexplorer.model.ForecastResult(
        timePeriodValue.map(value => value.editable),
        meanValueValue.map(value => value),
        predictionIntervalLowerBoundValue.map(value => value),
        predictionIntervalUpperBoundValue.map(value => value)
      )
    def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ]
    def meanValueValue: Option[GenericString]
    def predictionIntervalLowerBoundValue: Option[GenericString]
    def predictionIntervalUpperBoundValue: Option[GenericString]
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def meanValue: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("meanValue", meanValueValue)
    def predictionIntervalLowerBound: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "predictionIntervalLowerBound",
        predictionIntervalLowerBoundValue
      )
    def predictionIntervalUpperBound: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "predictionIntervalUpperBound",
        predictionIntervalUpperBoundValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ForecastResult
  ) extends io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly {
    override def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = scala
      .Option(impl.timePeriod())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(value)
      )
    override def meanValueValue: Option[GenericString] =
      scala.Option(impl.meanValue()).map(value => value: GenericString)
    override def predictionIntervalLowerBoundValue: Option[GenericString] =
      scala
        .Option(impl.predictionIntervalLowerBound())
        .map(value => value: GenericString)
    override def predictionIntervalUpperBoundValue: Option[GenericString] =
      scala
        .Option(impl.predictionIntervalUpperBound())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ForecastResult
  ): io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly =
    new Wrapper(impl)
}
