package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CurrentInstance(
    resourceId: Option[GenericString] = None,
    instanceName: Option[GenericString] = None,
    tags: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.TagValues]
    ] = None,
    resourceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails
    ] = None,
    resourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization
    ] = None,
    reservationCoveredHoursInLookbackPeriod: Option[GenericString] = None,
    savingsPlansCoveredHoursInLookbackPeriod: Option[GenericString] = None,
    onDemandHoursInLookbackPeriod: Option[GenericString] = None,
    totalRunningHoursInLookbackPeriod: Option[GenericString] = None,
    monthlyCost: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CurrentInstance = {
    import CurrentInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CurrentInstance
      .builder()
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(instanceName.map(value => value: java.lang.String))(
        _.instanceName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(
        _.resourceDetails
      )
      .optionallyWith(resourceUtilization.map(value => value.buildAwsValue()))(
        _.resourceUtilization
      )
      .optionallyWith(
        reservationCoveredHoursInLookbackPeriod.map(value =>
          value: java.lang.String
        )
      )(_.reservationCoveredHoursInLookbackPeriod)
      .optionallyWith(
        savingsPlansCoveredHoursInLookbackPeriod.map(value =>
          value: java.lang.String
        )
      )(_.savingsPlansCoveredHoursInLookbackPeriod)
      .optionallyWith(
        onDemandHoursInLookbackPeriod.map(value => value: java.lang.String)
      )(_.onDemandHoursInLookbackPeriod)
      .optionallyWith(
        totalRunningHoursInLookbackPeriod.map(value => value: java.lang.String)
      )(_.totalRunningHoursInLookbackPeriod)
      .optionallyWith(monthlyCost.map(value => value: java.lang.String))(
        _.monthlyCost
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CurrentInstance
      .wrap(buildAwsValue())
}
object CurrentInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CurrentInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CurrentInstance =
      io.github.vigoo.zioaws.costexplorer.model.CurrentInstance(
        resourceIdValue.map(value => value),
        instanceNameValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        resourceDetailsValue.map(value => value.editable),
        resourceUtilizationValue.map(value => value.editable),
        reservationCoveredHoursInLookbackPeriodValue.map(value => value),
        savingsPlansCoveredHoursInLookbackPeriodValue.map(value => value),
        onDemandHoursInLookbackPeriodValue.map(value => value),
        totalRunningHoursInLookbackPeriodValue.map(value => value),
        monthlyCostValue.map(value => value),
        currencyCodeValue.map(value => value)
      )
    def resourceIdValue: Option[GenericString]
    def instanceNameValue: Option[GenericString]
    def tagsValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly]
    ]
    def resourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ]
    def resourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ]
    def reservationCoveredHoursInLookbackPeriodValue: Option[GenericString]
    def savingsPlansCoveredHoursInLookbackPeriodValue: Option[GenericString]
    def onDemandHoursInLookbackPeriodValue: Option[GenericString]
    def totalRunningHoursInLookbackPeriodValue: Option[GenericString]
    def monthlyCostValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def resourceId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("resourceId", resourceIdValue)
    def instanceName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def resourceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("resourceDetails", resourceDetailsValue)
    def resourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceUtilization",
      resourceUtilizationValue
    )
    def reservationCoveredHoursInLookbackPeriod
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "reservationCoveredHoursInLookbackPeriod",
      reservationCoveredHoursInLookbackPeriodValue
    )
    def savingsPlansCoveredHoursInLookbackPeriod
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "savingsPlansCoveredHoursInLookbackPeriod",
      savingsPlansCoveredHoursInLookbackPeriodValue
    )
    def onDemandHoursInLookbackPeriod: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "onDemandHoursInLookbackPeriod",
        onDemandHoursInLookbackPeriodValue
      )
    def totalRunningHoursInLookbackPeriod: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "totalRunningHoursInLookbackPeriod",
        totalRunningHoursInLookbackPeriodValue
      )
    def monthlyCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("monthlyCost", monthlyCostValue)
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CurrentInstance
  ) extends io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly {
    override def resourceIdValue: Option[GenericString] =
      scala.Option(impl.resourceId()).map(value => value: GenericString)
    override def instanceNameValue: Option[GenericString] =
      scala.Option(impl.instanceName()).map(value => value: GenericString)
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.TagValues.wrap(item)
        }.toList
      )
    override def resourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly
    ] = scala
      .Option(impl.resourceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.wrap(value)
      )
    override def resourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.resourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization
          .wrap(value)
      )
    override def reservationCoveredHoursInLookbackPeriodValue
        : Option[GenericString] = scala
      .Option(impl.reservationCoveredHoursInLookbackPeriod())
      .map(value => value: GenericString)
    override def savingsPlansCoveredHoursInLookbackPeriodValue
        : Option[GenericString] = scala
      .Option(impl.savingsPlansCoveredHoursInLookbackPeriod())
      .map(value => value: GenericString)
    override def onDemandHoursInLookbackPeriodValue: Option[GenericString] =
      scala
        .Option(impl.onDemandHoursInLookbackPeriod())
        .map(value => value: GenericString)
    override def totalRunningHoursInLookbackPeriodValue: Option[GenericString] =
      scala
        .Option(impl.totalRunningHoursInLookbackPeriod())
        .map(value => value: GenericString)
    override def monthlyCostValue: Option[GenericString] =
      scala.Option(impl.monthlyCost()).map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CurrentInstance
  ): io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly =
    new Wrapper(impl)
}
