package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.CostCategoryValue
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategoryRule(
    value: Option[CostCategoryValue] = None,
    rule: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    inheritedValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension
    ] = None,
    `type`: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryRule = {
    import CostCategoryRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryRule
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .optionallyWith(inheritedValue.map(value => value.buildAwsValue()))(
        _.inheritedValue
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule
      .wrap(buildAwsValue())
}
object CostCategoryRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategoryRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule(
        valueValue.map(value => value),
        ruleValue.map(value => value.editable),
        inheritedValueValue.map(value => value.editable),
        typeValue.map(value => value)
      )
    def valueValue: Option[CostCategoryValue]
    def ruleValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def inheritedValueValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly
    ]
    def typeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType]
    def value: ZIO[Any, AwsError, CostCategoryValue] =
      AwsError.unwrapOptionField("value", valueValue)
    def rule: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("rule", ruleValue)
    def inheritedValue: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly
    ] = AwsError.unwrapOptionField("inheritedValue", inheritedValueValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType
    ] = AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryRule
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly {
    override def valueValue: Option[CostCategoryValue] =
      scala.Option(impl.value()).map(value => value: CostCategoryValue)
    override def ruleValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.rule())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def inheritedValueValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension.ReadOnly
    ] = scala
      .Option(impl.inheritedValue())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryInheritedValueDimension
          .wrap(value)
      )
    override def typeValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType
    ] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryRule
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly =
    new Wrapper(impl)
}
