package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericDouble
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Impact(
    maxImpact: GenericDouble,
    totalImpact: Option[GenericDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Impact = {
    import Impact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Impact
      .builder()
      .maxImpact(maxImpact: java.lang.Double)
      .optionallyWith(totalImpact.map(value => value: java.lang.Double))(
        _.totalImpact
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Impact.wrap(buildAwsValue())
}
object Impact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Impact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Impact =
      io.github.vigoo.zioaws.costexplorer.model
        .Impact(maxImpactValue, totalImpactValue.map(value => value))
    def maxImpactValue: GenericDouble
    def totalImpactValue: Option[GenericDouble]
    def maxImpact: ZIO[Any, Nothing, GenericDouble] =
      ZIO.succeed(maxImpactValue)
    def totalImpact: ZIO[Any, AwsError, GenericDouble] =
      AwsError.unwrapOptionField("totalImpact", totalImpactValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Impact
  ) extends io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly {
    override def maxImpactValue: GenericDouble = impl.maxImpact(): GenericDouble
    override def totalImpactValue: Option[GenericDouble] =
      scala.Option(impl.totalImpact()).map(value => value: GenericDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Impact
  ): io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly = new Wrapper(
    impl
  )
}
