package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  Value,
  CostCategoryName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategoryValues(
    key: Option[CostCategoryName] = None,
    values: Option[Iterable[Value]] = None,
    matchOptions: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.MatchOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryValues = {
    import CostCategoryValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryValues
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        matchOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchOptionsWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues
      .wrap(buildAwsValue())
}
object CostCategoryValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategoryValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues(
        keyValue.map(value => value),
        valuesValue.map(value => value),
        matchOptionsValue.map(value => value)
      )
    def keyValue: Option[CostCategoryName]
    def valuesValue: Option[List[Value]]
    def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]]
    def key: ZIO[Any, AwsError, CostCategoryName] =
      AwsError.unwrapOptionField("key", keyValue)
    def values: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def matchOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.MatchOption
    ]] = AwsError.unwrapOptionField("matchOptions", matchOptionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryValues
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly {
    override def keyValue: Option[CostCategoryName] =
      scala.Option(impl.key()).map(value => value: CostCategoryName)
    override def valuesValue: Option[List[Value]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: Value
        }.toList
      )
    override def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]] =
      scala
        .Option(impl.matchOptions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.costexplorer.model.MatchOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryValues
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly =
    new Wrapper(impl)
}
