package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TerminateRecommendationDetail(
    estimatedMonthlySavings: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail = {
    import TerminateRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail
      .builder()
      .optionallyWith(
        estimatedMonthlySavings.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavings)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail
      .wrap(buildAwsValue())
}
object TerminateRecommendationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail =
      io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail(
        estimatedMonthlySavingsValue.map(value => value),
        currencyCodeValue.map(value => value)
      )
    def estimatedMonthlySavingsValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def estimatedMonthlySavings: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavings",
        estimatedMonthlySavingsValue
      )
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail
  ) extends io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly {
    override def estimatedMonthlySavingsValue: Option[GenericString] = scala
      .Option(impl.estimatedMonthlySavings())
      .map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail
  ): io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly =
    new Wrapper(impl)
}
