package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansPurchaseRecommendationDetail(
    savingsPlansDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails
    ] = None,
    accountId: Option[GenericString] = None,
    upfrontCost: Option[GenericString] = None,
    estimatedROI: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None,
    estimatedSPCost: Option[GenericString] = None,
    estimatedOnDemandCost: Option[GenericString] = None,
    estimatedOnDemandCostWithCurrentCommitment: Option[GenericString] = None,
    estimatedSavingsAmount: Option[GenericString] = None,
    estimatedSavingsPercentage: Option[GenericString] = None,
    hourlyCommitmentToPurchase: Option[GenericString] = None,
    estimatedAverageUtilization: Option[GenericString] = None,
    estimatedMonthlySavingsAmount: Option[GenericString] = None,
    currentMinimumHourlyOnDemandSpend: Option[GenericString] = None,
    currentMaximumHourlyOnDemandSpend: Option[GenericString] = None,
    currentAverageHourlyOnDemandSpend: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail = {
    import SavingsPlansPurchaseRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
      .builder()
      .optionallyWith(savingsPlansDetails.map(value => value.buildAwsValue()))(
        _.savingsPlansDetails
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(upfrontCost.map(value => value: java.lang.String))(
        _.upfrontCost
      )
      .optionallyWith(estimatedROI.map(value => value: java.lang.String))(
        _.estimatedROI
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(estimatedSPCost.map(value => value: java.lang.String))(
        _.estimatedSPCost
      )
      .optionallyWith(
        estimatedOnDemandCost.map(value => value: java.lang.String)
      )(_.estimatedOnDemandCost)
      .optionallyWith(
        estimatedOnDemandCostWithCurrentCommitment.map(value =>
          value: java.lang.String
        )
      )(_.estimatedOnDemandCostWithCurrentCommitment)
      .optionallyWith(
        estimatedSavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedSavingsAmount)
      .optionallyWith(
        estimatedSavingsPercentage.map(value => value: java.lang.String)
      )(_.estimatedSavingsPercentage)
      .optionallyWith(
        hourlyCommitmentToPurchase.map(value => value: java.lang.String)
      )(_.hourlyCommitmentToPurchase)
      .optionallyWith(
        estimatedAverageUtilization.map(value => value: java.lang.String)
      )(_.estimatedAverageUtilization)
      .optionallyWith(
        estimatedMonthlySavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavingsAmount)
      .optionallyWith(
        currentMinimumHourlyOnDemandSpend.map(value => value: java.lang.String)
      )(_.currentMinimumHourlyOnDemandSpend)
      .optionallyWith(
        currentMaximumHourlyOnDemandSpend.map(value => value: java.lang.String)
      )(_.currentMaximumHourlyOnDemandSpend)
      .optionallyWith(
        currentAverageHourlyOnDemandSpend.map(value => value: java.lang.String)
      )(_.currentAverageHourlyOnDemandSpend)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
      .wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail =
      io.github.vigoo.zioaws.costexplorer.model
        .SavingsPlansPurchaseRecommendationDetail(
          savingsPlansDetailsValue.map(value => value.editable),
          accountIdValue.map(value => value),
          upfrontCostValue.map(value => value),
          estimatedROIValue.map(value => value),
          currencyCodeValue.map(value => value),
          estimatedSPCostValue.map(value => value),
          estimatedOnDemandCostValue.map(value => value),
          estimatedOnDemandCostWithCurrentCommitmentValue.map(value => value),
          estimatedSavingsAmountValue.map(value => value),
          estimatedSavingsPercentageValue.map(value => value),
          hourlyCommitmentToPurchaseValue.map(value => value),
          estimatedAverageUtilizationValue.map(value => value),
          estimatedMonthlySavingsAmountValue.map(value => value),
          currentMinimumHourlyOnDemandSpendValue.map(value => value),
          currentMaximumHourlyOnDemandSpendValue.map(value => value),
          currentAverageHourlyOnDemandSpendValue.map(value => value)
        )
    def savingsPlansDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly
    ]
    def accountIdValue: Option[GenericString]
    def upfrontCostValue: Option[GenericString]
    def estimatedROIValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def estimatedSPCostValue: Option[GenericString]
    def estimatedOnDemandCostValue: Option[GenericString]
    def estimatedOnDemandCostWithCurrentCommitmentValue: Option[GenericString]
    def estimatedSavingsAmountValue: Option[GenericString]
    def estimatedSavingsPercentageValue: Option[GenericString]
    def hourlyCommitmentToPurchaseValue: Option[GenericString]
    def estimatedAverageUtilizationValue: Option[GenericString]
    def estimatedMonthlySavingsAmountValue: Option[GenericString]
    def currentMinimumHourlyOnDemandSpendValue: Option[GenericString]
    def currentMaximumHourlyOnDemandSpendValue: Option[GenericString]
    def currentAverageHourlyOnDemandSpendValue: Option[GenericString]
    def savingsPlansDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savingsPlansDetails",
      savingsPlansDetailsValue
    )
    def accountId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def upfrontCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("upfrontCost", upfrontCostValue)
    def estimatedROI: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("estimatedROI", estimatedROIValue)
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def estimatedSPCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("estimatedSPCost", estimatedSPCostValue)
    def estimatedOnDemandCost: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("estimatedOnDemandCost", estimatedOnDemandCostValue)
    def estimatedOnDemandCostWithCurrentCommitment
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "estimatedOnDemandCostWithCurrentCommitment",
      estimatedOnDemandCostWithCurrentCommitmentValue
    )
    def estimatedSavingsAmount: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("estimatedSavingsAmount", estimatedSavingsAmountValue)
    def estimatedSavingsPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedSavingsPercentage",
        estimatedSavingsPercentageValue
      )
    def hourlyCommitmentToPurchase: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "hourlyCommitmentToPurchase",
        hourlyCommitmentToPurchaseValue
      )
    def estimatedAverageUtilization: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedAverageUtilization",
        estimatedAverageUtilizationValue
      )
    def estimatedMonthlySavingsAmount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavingsAmount",
        estimatedMonthlySavingsAmountValue
      )
    def currentMinimumHourlyOnDemandSpend: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "currentMinimumHourlyOnDemandSpend",
        currentMinimumHourlyOnDemandSpendValue
      )
    def currentMaximumHourlyOnDemandSpend: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "currentMaximumHourlyOnDemandSpend",
        currentMaximumHourlyOnDemandSpendValue
      )
    def currentAverageHourlyOnDemandSpend: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "currentAverageHourlyOnDemandSpend",
        currentAverageHourlyOnDemandSpendValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly {
    override def savingsPlansDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly
    ] = scala
      .Option(impl.savingsPlansDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails
          .wrap(value)
      )
    override def accountIdValue: Option[GenericString] =
      scala.Option(impl.accountId()).map(value => value: GenericString)
    override def upfrontCostValue: Option[GenericString] =
      scala.Option(impl.upfrontCost()).map(value => value: GenericString)
    override def estimatedROIValue: Option[GenericString] =
      scala.Option(impl.estimatedROI()).map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
    override def estimatedSPCostValue: Option[GenericString] =
      scala.Option(impl.estimatedSPCost()).map(value => value: GenericString)
    override def estimatedOnDemandCostValue: Option[GenericString] = scala
      .Option(impl.estimatedOnDemandCost())
      .map(value => value: GenericString)
    override def estimatedOnDemandCostWithCurrentCommitmentValue
        : Option[GenericString] = scala
      .Option(impl.estimatedOnDemandCostWithCurrentCommitment())
      .map(value => value: GenericString)
    override def estimatedSavingsAmountValue: Option[GenericString] = scala
      .Option(impl.estimatedSavingsAmount())
      .map(value => value: GenericString)
    override def estimatedSavingsPercentageValue: Option[GenericString] = scala
      .Option(impl.estimatedSavingsPercentage())
      .map(value => value: GenericString)
    override def hourlyCommitmentToPurchaseValue: Option[GenericString] = scala
      .Option(impl.hourlyCommitmentToPurchase())
      .map(value => value: GenericString)
    override def estimatedAverageUtilizationValue: Option[GenericString] = scala
      .Option(impl.estimatedAverageUtilization())
      .map(value => value: GenericString)
    override def estimatedMonthlySavingsAmountValue: Option[GenericString] =
      scala
        .Option(impl.estimatedMonthlySavingsAmount())
        .map(value => value: GenericString)
    override def currentMinimumHourlyOnDemandSpendValue: Option[GenericString] =
      scala
        .Option(impl.currentMinimumHourlyOnDemandSpend())
        .map(value => value: GenericString)
    override def currentMaximumHourlyOnDemandSpendValue: Option[GenericString] =
      scala
        .Option(impl.currentMaximumHourlyOnDemandSpend())
        .map(value => value: GenericString)
    override def currentAverageHourlyOnDemandSpendValue: Option[GenericString] =
      scala
        .Option(impl.currentAverageHourlyOnDemandSpend())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly =
    new Wrapper(impl)
}
