package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  PageSize,
  NextPageToken,
  Value
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomalyMonitorsRequest(
    monitorArnList: Option[Iterable[Value]] = None,
    nextPageToken: Option[NextPageToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest = {
    import GetAnomalyMonitorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest
      .builder()
      .optionallyWith(
        monitorArnList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.monitorArnList)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest
      .wrap(buildAwsValue())
}
object GetAnomalyMonitorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest(
        monitorArnListValue.map(value => value),
        nextPageTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def monitorArnListValue: Option[List[Value]]
    def nextPageTokenValue: Option[NextPageToken]
    def maxResultsValue: Option[PageSize]
    def monitorArnList: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("monitorArnList", monitorArnListValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest.ReadOnly {
    override def monitorArnListValue: Option[List[Value]] = scala
      .Option(impl.monitorArnList())
      .map(value =>
        value.asScala.map { item =>
          item: Value
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def maxResultsValue: Option[PageSize] =
      scala.Option(impl.maxResults()).map(value => value: PageSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsRequest.ReadOnly =
    new Wrapper(impl)
}
