package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  GenericBoolean,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2InstanceDetails(
    family: Option[GenericString] = None,
    instanceType: Option[GenericString] = None,
    region: Option[GenericString] = None,
    availabilityZone: Option[GenericString] = None,
    platform: Option[GenericString] = None,
    tenancy: Option[GenericString] = None,
    currentGeneration: Option[GenericBoolean] = None,
    sizeFlexEligible: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails = {
    import EC2InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails
      .builder()
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(tenancy.map(value => value: java.lang.String))(_.tenancy)
      .optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(
        _.currentGeneration
      )
      .optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(
        _.sizeFlexEligible
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails
      .wrap(buildAwsValue())
}
object EC2InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails =
      io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails(
        familyValue.map(value => value),
        instanceTypeValue.map(value => value),
        regionValue.map(value => value),
        availabilityZoneValue.map(value => value),
        platformValue.map(value => value),
        tenancyValue.map(value => value),
        currentGenerationValue.map(value => value),
        sizeFlexEligibleValue.map(value => value)
      )
    def familyValue: Option[GenericString]
    def instanceTypeValue: Option[GenericString]
    def regionValue: Option[GenericString]
    def availabilityZoneValue: Option[GenericString]
    def platformValue: Option[GenericString]
    def tenancyValue: Option[GenericString]
    def currentGenerationValue: Option[GenericBoolean]
    def sizeFlexEligibleValue: Option[GenericBoolean]
    def family: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("family", familyValue)
    def instanceType: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def availabilityZone: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def platform: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("platform", platformValue)
    def tenancy: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("tenancy", tenancyValue)
    def currentGeneration: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly {
    override def familyValue: Option[GenericString] =
      scala.Option(impl.family()).map(value => value: GenericString)
    override def instanceTypeValue: Option[GenericString] =
      scala.Option(impl.instanceType()).map(value => value: GenericString)
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def availabilityZoneValue: Option[GenericString] =
      scala.Option(impl.availabilityZone()).map(value => value: GenericString)
    override def platformValue: Option[GenericString] =
      scala.Option(impl.platform()).map(value => value: GenericString)
    override def tenancyValue: Option[GenericString] =
      scala.Option(impl.tenancy()).map(value => value: GenericString)
    override def currentGenerationValue: Option[GenericBoolean] =
      scala.Option(impl.currentGeneration()).map(value => value: GenericBoolean)
    override def sizeFlexEligibleValue: Option[GenericBoolean] =
      scala.Option(impl.sizeFlexEligible()).map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.EC2InstanceDetails.ReadOnly =
    new Wrapper(impl)
}
