package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansPurchaseRecommendation(
    accountScope: Option[
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = None,
    savingsPlansType: Option[
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    ] = None,
    termInYears: Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] =
      None,
    paymentOption: Option[
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = None,
    lookbackPeriodInDays: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = None,
    savingsPlansPurchaseRecommendationDetails: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
    ]] = None,
    savingsPlansPurchaseRecommendationSummary: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation = {
    import SavingsPlansPurchaseRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation
      .builder()
      .optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope)
      .optionallyWith(savingsPlansType.map(value => value.unwrap))(
        _.savingsPlansType
      )
      .optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(
        _.lookbackPeriodInDays
      )
      .optionallyWith(
        savingsPlansPurchaseRecommendationDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.savingsPlansPurchaseRecommendationDetails)
      .optionallyWith(
        savingsPlansPurchaseRecommendationSummary.map(value =>
          value.buildAwsValue()
        )
      )(_.savingsPlansPurchaseRecommendationSummary)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation
      .wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation =
      io.github.vigoo.zioaws.costexplorer.model
        .SavingsPlansPurchaseRecommendation(
          accountScopeValue.map(value => value),
          savingsPlansTypeValue.map(value => value),
          termInYearsValue.map(value => value),
          paymentOptionValue.map(value => value),
          lookbackPeriodInDaysValue.map(value => value),
          savingsPlansPurchaseRecommendationDetailsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          savingsPlansPurchaseRecommendationSummaryValue.map(value =>
            value.editable
          )
        )
    def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope]
    def savingsPlansTypeValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    ]
    def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears]
    def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption]
    def lookbackPeriodInDaysValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays]
    def savingsPlansPurchaseRecommendationDetailsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly
    ]]
    def savingsPlansPurchaseRecommendationSummaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly
    ]
    def accountScope: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def savingsPlansType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    ] = AwsError.unwrapOptionField("savingsPlansType", savingsPlansTypeValue)
    def termInYears: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TermInYears
    ] = AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def lookbackPeriodInDays: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = AwsError.unwrapOptionField(
      "lookbackPeriodInDays",
      lookbackPeriodInDaysValue
    )
    def savingsPlansPurchaseRecommendationDetails: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "savingsPlansPurchaseRecommendationDetails",
      savingsPlansPurchaseRecommendationDetailsValue
    )
    def savingsPlansPurchaseRecommendationSummary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savingsPlansPurchaseRecommendationSummary",
      savingsPlansPurchaseRecommendationSummaryValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly {
    override def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope] = scala
      .Option(impl.accountScope())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AccountScope.wrap(value)
      )
    override def savingsPlansTypeValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    ] = scala
      .Option(impl.savingsPlansType())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
          .wrap(value)
      )
    override def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] = scala
      .Option(impl.termInYears())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.TermInYears.wrap(value)
      )
    override def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption] =
      scala
        .Option(impl.paymentOption())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.PaymentOption.wrap(value)
        )
    override def lookbackPeriodInDaysValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = scala
      .Option(impl.lookbackPeriodInDays())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
          .wrap(value)
      )
    override def savingsPlansPurchaseRecommendationDetailsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail.ReadOnly
    ]] = scala
      .Option(impl.savingsPlansPurchaseRecommendationDetails())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationDetail
            .wrap(item)
        }.toList
      )
    override def savingsPlansPurchaseRecommendationSummaryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.ReadOnly
    ] = scala
      .Option(impl.savingsPlansPurchaseRecommendationSummary())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly =
    new Wrapper(impl)
}
