package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  PageSize,
  NextPageToken,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomaliesRequest(
    monitorArn: Option[GenericString] = None,
    dateInterval: io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval,
    feedback: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = None,
    totalImpact: Option[
      io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter
    ] = None,
    nextPageToken: Option[NextPageToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest = {
    import GetAnomaliesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest
      .builder()
      .optionallyWith(monitorArn.map(value => value: java.lang.String))(
        _.monitorArn
      )
      .dateInterval(dateInterval.buildAwsValue())
      .optionallyWith(feedback.map(value => value.unwrap))(_.feedback)
      .optionallyWith(totalImpact.map(value => value.buildAwsValue()))(
        _.totalImpact
      )
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest
      .wrap(buildAwsValue())
}
object GetAnomaliesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest(
        monitorArnValue.map(value => value),
        dateIntervalValue.editable,
        feedbackValue.map(value => value),
        totalImpactValue.map(value => value.editable),
        nextPageTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def monitorArnValue: Option[GenericString]
    def dateIntervalValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly
    def feedbackValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType]
    def totalImpactValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def maxResultsValue: Option[PageSize]
    def monitorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def dateInterval: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly
    ] = ZIO.succeed(dateIntervalValue)
    def feedback: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = AwsError.unwrapOptionField("feedback", feedbackValue)
    def totalImpact: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly
    ] = AwsError.unwrapOptionField("totalImpact", totalImpactValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest.ReadOnly {
    override def monitorArnValue: Option[GenericString] =
      scala.Option(impl.monitorArn()).map(value => value: GenericString)
    override def dateIntervalValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval
        .wrap(impl.dateInterval())
    override def feedbackValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = scala
      .Option(impl.feedback())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
          .wrap(value)
      )
    override def totalImpactValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.ReadOnly
    ] = scala
      .Option(impl.totalImpact())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.TotalImpactFilter.wrap(value)
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def maxResultsValue: Option[PageSize] =
      scala.Option(impl.maxResults()).map(value => value: PageSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesRequest.ReadOnly =
    new Wrapper(impl)
}
