package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Expression(
    or: Option[Iterable[io.github.vigoo.zioaws.costexplorer.model.Expression]] =
      None,
    and: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.Expression]
    ] = None,
    not: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    dimensions: Option[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValues
    ] = None,
    tags: Option[io.github.vigoo.zioaws.costexplorer.model.TagValues] = None,
    costCategories: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Expression = {
    import Expression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Expression
      .builder()
      .optionallyWith(
        or.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.or)
      .optionallyWith(
        and.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.and)
      .optionallyWith(not.map(value => value.buildAwsValue()))(_.not)
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .optionallyWith(costCategories.map(value => value.buildAwsValue()))(
        _.costCategories
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(buildAwsValue())
}
object Expression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Expression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Expression =
      io.github.vigoo.zioaws.costexplorer.model.Expression(
        orValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        andValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        notValue.map(value => value.editable),
        dimensionsValue.map(value => value.editable),
        tagsValue.map(value => value.editable),
        costCategoriesValue.map(value => value.editable)
      )
    def orValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    ]
    def andValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    ]
    def notValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def dimensionsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly
    ]
    def tagsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly]
    def costCategoriesValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly
    ]
    def or: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ]] = AwsError.unwrapOptionField("or", orValue)
    def and: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ]] = AwsError.unwrapOptionField("and", andValue)
    def not: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("not", notValue)
    def dimensions: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly
    ] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def tags: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly
    ] = AwsError.unwrapOptionField("tags", tagsValue)
    def costCategories: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly
    ] = AwsError.unwrapOptionField("costCategories", costCategoriesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Expression
  ) extends io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly {
    override def orValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    ] = scala
      .Option(impl.or())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(item)
        }.toList
      )
    override def andValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    ] = scala
      .Option(impl.and())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(item)
        }.toList
      )
    override def notValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.not())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def dimensionsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValues.ReadOnly
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DimensionValues.wrap(value)
      )
    override def tagsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly] =
      scala
        .Option(impl.tags())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.TagValues.wrap(value)
        )
    override def costCategoriesValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.ReadOnly
    ] = scala
      .Option(impl.costCategories())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryValues.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Expression
  ): io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly =
    new Wrapper(impl)
}
