package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{ZonedDateTime, Arn}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCostCategoryDefinitionRequest(
    costCategoryArn: Arn,
    effectiveOn: Option[ZonedDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest = {
    import DescribeCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest
      .builder()
      .costCategoryArn(costCategoryArn: java.lang.String)
      .optionallyWith(effectiveOn.map(value => value: java.lang.String))(
        _.effectiveOn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest
      .wrap(buildAwsValue())
}
object DescribeCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .DescribeCostCategoryDefinitionRequest(
          costCategoryArnValue,
          effectiveOnValue.map(value => value)
        )
    def costCategoryArnValue: Arn
    def effectiveOnValue: Option[ZonedDateTime]
    def costCategoryArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(costCategoryArnValue)
    def effectiveOn: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveOn", effectiveOnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest.ReadOnly {
    override def costCategoryArnValue: Arn = impl.costCategoryArn(): Arn
    override def effectiveOnValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveOn()).map(value => value: ZonedDateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest
  ): io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
