package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SortDefinition(key: primitives.SortDefinitionKey, sortOrder: scala.Option[SortOrder] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SortDefinition = {
    import SortDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SortDefinition.builder().key(key: java.lang.String).optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder).build()
  }
  def asReadOnly: SortDefinition.ReadOnly = SortDefinition.wrap(buildAwsValue())
}
object SortDefinition {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SortDefinition] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SortDefinition = SortDefinition(keyValue, sortOrderValue.map(value => value))
    def keyValue: primitives.SortDefinitionKey
    def sortOrderValue: scala.Option[SortOrder]
    def key: ZIO[Any, Nothing, primitives.SortDefinitionKey] = ZIO.succeed(keyValue)
    def sortOrder: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SortOrder] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortOrder", sortOrderValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SortDefinition) extends SortDefinition.ReadOnly {
    override def keyValue: primitives.SortDefinitionKey = impl.key(): primitives.SortDefinitionKey
    override def sortOrderValue: scala.Option[SortOrder] = scala.Option(impl.sortOrder()).map(value => SortOrder.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SortDefinition): ReadOnly = new Wrapper(impl)
}