package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomalyMonitorsRequest(monitorArnList: scala.Option[Iterable[primitives.Value]] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.PageSize] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest = {
    import GetAnomalyMonitorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest.builder().optionallyWith(monitorArnList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.monitorArnList).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: GetAnomalyMonitorsRequest.ReadOnly = GetAnomalyMonitorsRequest.wrap(buildAwsValue())
}
object GetAnomalyMonitorsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomalyMonitorsRequest = GetAnomalyMonitorsRequest(monitorArnListValue.map(value => value), nextPageTokenValue.map(value => value), maxResultsValue.map(value => value))
    def monitorArnListValue: scala.Option[List[primitives.Value]]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.PageSize]
    def monitorArnList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Value]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorArnList", monitorArnListValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PageSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest) extends GetAnomalyMonitorsRequest.ReadOnly {
    override def monitorArnListValue: scala.Option[List[primitives.Value]] = scala.Option(impl.monitorArnList()).map(value => value.asScala.map { item => 
      item: primitives.Value
    }.toList)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.PageSize] = scala.Option(impl.maxResults()).map(value => value: primitives.PageSize)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest): ReadOnly = new Wrapper(impl)
}