package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SupportedSavingsPlansType { def unwrap: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType }
object SupportedSavingsPlansType {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType): SupportedSavingsPlansType = value match {
    case software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.COMPUTE_SP =>
      val r = COMPUTE_SP
      r
    case software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.EC2_INSTANCE_SP =>
      val r = EC2_INSTANCE_SP
      r
    case software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.SAGEMAKER_SP =>
      val r = SAGEMAKER_SP
      r
  }
  case object unknownToSdkVersion extends SupportedSavingsPlansType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType = software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.UNKNOWN_TO_SDK_VERSION }
  case object COMPUTE_SP extends SupportedSavingsPlansType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType = software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.COMPUTE_SP }
  case object EC2_INSTANCE_SP extends SupportedSavingsPlansType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType = software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.EC2_INSTANCE_SP }
  case object SAGEMAKER_SP extends SupportedSavingsPlansType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType = software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType.SAGEMAKER_SP }
}