package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CoverageByTime(timePeriod: scala.Option[DateInterval] = None, groups: scala.Option[Iterable[ReservationCoverageGroup]] = None, total: scala.Option[Coverage] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CoverageByTime = {
    import CoverageByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageByTime.builder().optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(groups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groups).optionallyWith(total.map(value => value.buildAwsValue()))(_.total).build()
  }
  def asReadOnly: CoverageByTime.ReadOnly = CoverageByTime.wrap(buildAwsValue())
}
object CoverageByTime {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CoverageByTime] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CoverageByTime = CoverageByTime(timePeriodValue.map(value => value.editable), groupsValue.map(value => value.map { item => 
      item.editable
    }), totalValue.map(value => value.editable))
    def timePeriodValue: scala.Option[DateInterval.ReadOnly]
    def groupsValue: scala.Option[List[ReservationCoverageGroup.ReadOnly]]
    def totalValue: scala.Option[Coverage.ReadOnly]
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DateInterval.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def groups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservationCoverageGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groups", groupsValue)
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Coverage.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CoverageByTime) extends CoverageByTime.ReadOnly {
    override def timePeriodValue: scala.Option[DateInterval.ReadOnly] = scala.Option(impl.timePeriod()).map(value => DateInterval.wrap(value))
    override def groupsValue: scala.Option[List[ReservationCoverageGroup.ReadOnly]] = scala.Option(impl.groups()).map(value => value.asScala.map { item => 
      ReservationCoverageGroup.wrap(item)
    }.toList)
    override def totalValue: scala.Option[Coverage.ReadOnly] = scala.Option(impl.total()).map(value => Coverage.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CoverageByTime): ReadOnly = new Wrapper(impl)
}