package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait Context { def unwrap: software.amazon.awssdk.services.costexplorer.model.Context }
object Context {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.Context): Context = value match {
    case software.amazon.awssdk.services.costexplorer.model.Context.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.Context.COST_AND_USAGE =>
      val r = COST_AND_USAGE
      r
    case software.amazon.awssdk.services.costexplorer.model.Context.RESERVATIONS =>
      val r = RESERVATIONS
      r
    case software.amazon.awssdk.services.costexplorer.model.Context.SAVINGS_PLANS =>
      val r = SAVINGS_PLANS
      r
  }
  case object unknownToSdkVersion extends Context { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Context = software.amazon.awssdk.services.costexplorer.model.Context.UNKNOWN_TO_SDK_VERSION }
  case object COST_AND_USAGE extends Context { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Context = software.amazon.awssdk.services.costexplorer.model.Context.COST_AND_USAGE }
  case object RESERVATIONS extends Context { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Context = software.amazon.awssdk.services.costexplorer.model.Context.RESERVATIONS }
  case object SAVINGS_PLANS extends Context { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Context = software.amazon.awssdk.services.costexplorer.model.Context.SAVINGS_PLANS }
}