package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AnomalySubscriptionFrequency { def unwrap: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency }
object AnomalySubscriptionFrequency {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency): AnomalySubscriptionFrequency = value match {
    case software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.IMMEDIATE =>
      val r = IMMEDIATE
      r
    case software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.WEEKLY =>
      val r = WEEKLY
      r
  }
  case object unknownToSdkVersion extends AnomalySubscriptionFrequency { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency = software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.UNKNOWN_TO_SDK_VERSION }
  case object DAILY extends AnomalySubscriptionFrequency { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency = software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.DAILY }
  case object IMMEDIATE extends AnomalySubscriptionFrequency { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency = software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.IMMEDIATE }
  case object WEEKLY extends AnomalySubscriptionFrequency { override def unwrap: software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency = software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency.WEEKLY }
}