package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateAnomalySubscriptionRequest(subscriptionArn: primitives.GenericString, threshold: scala.Option[primitives.NullableNonNegativeDouble] = None, frequency: scala.Option[AnomalySubscriptionFrequency] = None, monitorArnList: scala.Option[Iterable[primitives.Arn]] = None, subscribers: scala.Option[Iterable[Subscriber]] = None, subscriptionName: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest = {
    import UpdateAnomalySubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest.builder().subscriptionArn(subscriptionArn: java.lang.String).optionallyWith(threshold.map(value => value: java.lang.Double))(_.threshold).optionallyWith(frequency.map(value => value.unwrap))(_.frequency).optionallyWith(monitorArnList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.monitorArnList).optionallyWith(subscribers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.subscribers).optionallyWith(subscriptionName.map(value => value: java.lang.String))(_.subscriptionName).build()
  }
  def asReadOnly: UpdateAnomalySubscriptionRequest.ReadOnly = UpdateAnomalySubscriptionRequest.wrap(buildAwsValue())
}
object UpdateAnomalySubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateAnomalySubscriptionRequest = UpdateAnomalySubscriptionRequest(subscriptionArnValue, thresholdValue.map(value => value), frequencyValue.map(value => value), monitorArnListValue.map(value => value), subscribersValue.map(value => value.map { item => 
      item.editable
    }), subscriptionNameValue.map(value => value))
    def subscriptionArnValue: primitives.GenericString
    def thresholdValue: scala.Option[primitives.NullableNonNegativeDouble]
    def frequencyValue: scala.Option[AnomalySubscriptionFrequency]
    def monitorArnListValue: scala.Option[List[primitives.Arn]]
    def subscribersValue: scala.Option[List[Subscriber.ReadOnly]]
    def subscriptionNameValue: scala.Option[primitives.GenericString]
    def subscriptionArn: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(subscriptionArnValue)
    def threshold: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NullableNonNegativeDouble] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("threshold", thresholdValue)
    def frequency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AnomalySubscriptionFrequency] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("frequency", frequencyValue)
    def monitorArnList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Arn]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorArnList", monitorArnListValue)
    def subscribers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Subscriber.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscribers", subscribersValue)
    def subscriptionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionName", subscriptionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest) extends UpdateAnomalySubscriptionRequest.ReadOnly {
    override def subscriptionArnValue: primitives.GenericString = impl.subscriptionArn(): primitives.GenericString
    override def thresholdValue: scala.Option[primitives.NullableNonNegativeDouble] = scala.Option(impl.threshold()).map(value => value: primitives.NullableNonNegativeDouble)
    override def frequencyValue: scala.Option[AnomalySubscriptionFrequency] = scala.Option(impl.frequency()).map(value => AnomalySubscriptionFrequency.wrap(value))
    override def monitorArnListValue: scala.Option[List[primitives.Arn]] = scala.Option(impl.monitorArnList()).map(value => value.asScala.map { item => 
      item: primitives.Arn
    }.toList)
    override def subscribersValue: scala.Option[List[Subscriber.ReadOnly]] = scala.Option(impl.subscribers()).map(value => value.asScala.map { item => 
      Subscriber.wrap(item)
    }.toList)
    override def subscriptionNameValue: scala.Option[primitives.GenericString] = scala.Option(impl.subscriptionName()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest): ReadOnly = new Wrapper(impl)
}