package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TargetInstance(estimatedMonthlyCost: scala.Option[primitives.GenericString] = None, estimatedMonthlySavings: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None, defaultTargetInstance: scala.Option[primitives.GenericBoolean] = None, resourceDetails: scala.Option[ResourceDetails] = None, expectedResourceUtilization: scala.Option[ResourceUtilization] = None, platformDifferences: scala.Option[Iterable[PlatformDifference]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.TargetInstance = {
    import TargetInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TargetInstance.builder().optionallyWith(estimatedMonthlyCost.map(value => value: java.lang.String))(_.estimatedMonthlyCost).optionallyWith(estimatedMonthlySavings.map(value => value: java.lang.String))(_.estimatedMonthlySavings).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).optionallyWith(defaultTargetInstance.map(value => value: java.lang.Boolean))(_.defaultTargetInstance).optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(_.resourceDetails).optionallyWith(expectedResourceUtilization.map(value => value.buildAwsValue()))(_.expectedResourceUtilization).optionallyWith(platformDifferences.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.platformDifferencesWithStrings).build()
  }
  def asReadOnly: TargetInstance.ReadOnly = TargetInstance.wrap(buildAwsValue())
}
object TargetInstance {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.TargetInstance] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TargetInstance = TargetInstance(estimatedMonthlyCostValue.map(value => value), estimatedMonthlySavingsValue.map(value => value), currencyCodeValue.map(value => value), defaultTargetInstanceValue.map(value => value), resourceDetailsValue.map(value => value.editable), expectedResourceUtilizationValue.map(value => value.editable), platformDifferencesValue.map(value => value))
    def estimatedMonthlyCostValue: scala.Option[primitives.GenericString]
    def estimatedMonthlySavingsValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def defaultTargetInstanceValue: scala.Option[primitives.GenericBoolean]
    def resourceDetailsValue: scala.Option[ResourceDetails.ReadOnly]
    def expectedResourceUtilizationValue: scala.Option[ResourceUtilization.ReadOnly]
    def platformDifferencesValue: scala.Option[List[PlatformDifference]]
    def estimatedMonthlyCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlyCost", estimatedMonthlyCostValue)
    def estimatedMonthlySavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlySavings", estimatedMonthlySavingsValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def defaultTargetInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultTargetInstance", defaultTargetInstanceValue)
    def resourceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceDetails", resourceDetailsValue)
    def expectedResourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expectedResourceUtilization", expectedResourceUtilizationValue)
    def platformDifferences: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PlatformDifference]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platformDifferences", platformDifferencesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.TargetInstance) extends TargetInstance.ReadOnly {
    override def estimatedMonthlyCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlyCost()).map(value => value: primitives.GenericString)
    override def estimatedMonthlySavingsValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlySavings()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
    override def defaultTargetInstanceValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.defaultTargetInstance()).map(value => value: primitives.GenericBoolean)
    override def resourceDetailsValue: scala.Option[ResourceDetails.ReadOnly] = scala.Option(impl.resourceDetails()).map(value => ResourceDetails.wrap(value))
    override def expectedResourceUtilizationValue: scala.Option[ResourceUtilization.ReadOnly] = scala.Option(impl.expectedResourceUtilization()).map(value => ResourceUtilization.wrap(value))
    override def platformDifferencesValue: scala.Option[List[PlatformDifference]] = scala.Option(impl.platformDifferences()).map(value => value.asScala.map { item => 
      PlatformDifference.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.TargetInstance): ReadOnly = new Wrapper(impl)
}