package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Subscriber(address: scala.Option[primitives.SubscriberAddress] = None, `type`: scala.Option[SubscriberType] = None, status: scala.Option[SubscriberStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Subscriber = {
    import Subscriber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Subscriber.builder().optionallyWith(address.map(value => value: java.lang.String))(_.address).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(status.map(value => value.unwrap))(_.status).build()
  }
  def asReadOnly: Subscriber.ReadOnly = Subscriber.wrap(buildAwsValue())
}
object Subscriber {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Subscriber] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Subscriber = Subscriber(addressValue.map(value => value), typeValue.map(value => value), statusValue.map(value => value))
    def addressValue: scala.Option[primitives.SubscriberAddress]
    def typeValue: scala.Option[SubscriberType]
    def statusValue: scala.Option[SubscriberStatus]
    def address: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SubscriberAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("address", addressValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SubscriberType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SubscriberStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Subscriber) extends Subscriber.ReadOnly {
    override def addressValue: scala.Option[primitives.SubscriberAddress] = scala.Option(impl.address()).map(value => value: primitives.SubscriberAddress)
    override def typeValue: scala.Option[SubscriberType] = scala.Option(impl.`type`()).map(value => SubscriberType.wrap(value))
    override def statusValue: scala.Option[SubscriberStatus] = scala.Option(impl.status()).map(value => SubscriberStatus.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Subscriber): ReadOnly = new Wrapper(impl)
}