package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SortOrder { def unwrap: software.amazon.awssdk.services.costexplorer.model.SortOrder }
object SortOrder {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.SortOrder): SortOrder = value match {
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.costexplorer.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends SortOrder { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SortOrder = software.amazon.awssdk.services.costexplorer.model.SortOrder.UNKNOWN_TO_SDK_VERSION }
  case object ASCENDING extends SortOrder { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SortOrder = software.amazon.awssdk.services.costexplorer.model.SortOrder.ASCENDING }
  case object DESCENDING extends SortOrder { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SortOrder = software.amazon.awssdk.services.costexplorer.model.SortOrder.DESCENDING }
}